/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class EditPhoneNumberBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSEPBT";
    private static final String TRACE_MASKF = "XRCSEPBF";
    private static final String TRACE_MASKD = "XRCSEPBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-EPhoBean");
    private PhoneInfo phoneInfo;
    private String m_sDialPrefix;
    private String m_sPhoneNumber;
    private String m_sComment;

    public void setDialPrefix(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> setDialPrefix(" + s + ")");
        this.m_sDialPrefix = s;
    }

    public String getDialPrefix() {
        return this.m_sDialPrefix;
    }

    public void setPhoneNumber(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setPhoneNumber(" + s + ")");
        this.m_sPhoneNumber = s.trim();
        LocalizableText errMsg = PhoneInfo.validatePhoneNumber(this.m_sPhoneNumber);
        if (errMsg != null) {
            throw new IllegalUserDataException(errMsg.toString());
        }
        Trace.trace(TRACE_MASKT, "<- setPhoneNumber()");
    }

    public String getPhoneNumber() {
        return this.m_sPhoneNumber;
    }

    public void setComment(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> setComment(" + s + ")");
        this.m_sComment = s.trim();
    }

    public String getComment() {
        return this.m_sComment;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        if (this.m_sDialPrefix == null) {
            this.m_sDialPrefix = "";
        }
        this.m_sPhoneNumber = "";
        this.m_sComment = "";
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setPhoneInfo(PhoneInfo info) {
        this.phoneInfo = info;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            if (element.endsWith("OkButton")) {
                try {
                    this.userTaskManager.storeAllElements();
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("EditPhoneNumberBean");
                    request.setData("Source", "EditPhoneNumberPanel");
                    request.setData("Command", "Commit");
                    request.setData("PhoneInfo", this.createUpdatedPhoneInfo());
                    this.postTaskletRequest(request);
                }
                catch (IllegalUserDataException iude) {}
            } else if (element.endsWith("CancelButton")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setSource("EditPhoneNumberBean");
                request.setData("Source", "EditPhoneNumberPanel");
                request.setData("Command", "Cancel");
                this.postTaskletRequest(request);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown element");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- update");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        if (initialUpdate) {
            this.m_sPhoneNumber = this.phoneInfo.getPhoneNumber();
            this.m_sComment = this.phoneInfo.getDescription();
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }

    private void validatePhoneNumber(String number) throws IllegalUserDataException {
        if (number == null || number.equals("")) {
            LocalizableText errMsg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "FIELD_REQUIRED");
            throw new IllegalUserDataException(errMsg.toString());
        }
        for (int i = 0; i < number.length(); ++i) {
            char thisChar = number.charAt(i);
            if ("(-)0123456789".indexOf(thisChar) != -1) continue;
            Object[] subst = new Object[]{"'(-)0123456789'"};
            LocalizableText errMsg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "FIELD_MAY_CONTAIN", subst);
            throw new IllegalUserDataException(errMsg.toString());
        }
    }

    private PhoneInfo createUpdatedPhoneInfo() {
        String number = this.m_sPhoneNumber.trim();
        String desc = this.m_sComment.trim();
        String baseNumber = this.phoneInfo.getPredefinedNumber();
        String countryCode = this.phoneInfo.getIsoCountryCode();
        String subdivisionCode = this.phoneInfo.getIsoSubdivisionCode();
        PhoneInfo info = new PhoneInfo(number, desc, countryCode, subdivisionCode, baseNumber);
        return info;
    }
}

